package gov.va.med.mhv.mrp.web.converter;

import java.io.Serializable;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.mrp.common.dto.MyGoalTaskDTO;
import gov.va.med.mhv.mrp.common.dto.MyGoalsTaskActivitiesDTO;
import gov.va.med.mhv.mrp.web.model.MyGoalTask;
import gov.va.med.mhv.mrp.web.model.MyGoalTaskActivity;

@Component
public class MyGoalTaskConverter implements Converter<MyGoalTaskDTO, MyGoalTask>, Serializable {
	private static final long serialVersionUID = 1L;

	@Autowired
	private MyGoalTaskActivityConverter myGoalTaskActivityConverter;
	
	@Override
	public MyGoalTask convert(MyGoalTaskDTO dto) {
		MyGoalTask model = new MyGoalTask();
		
		model.setCompletedDate(dto.getCompletedDate());
		model.setCompletionType(dto.getCompletionType());
		model.setDescription(dto.getDescription());
		model.setEndDate(dto.getEndDate());
		model.setEndTime(dto.getEndTime());
		model.setGoalExtensionId(dto.getGoalExtensionId());
		model.setTaskId(dto.getTaskId());
		model.setStartDate(dto.getStartDate());
		model.setStartTime(dto.getStartTime());
		model.setStatus(dto.getStatus());
		model.setTaskName(dto.getTaskName());
		model.setTaskRepetitionCycleType(dto.getTaskRepetitionCycleType());
		model.setTaskSequenceNumber(dto.getTaskSequenceNumber());
		model.setOplock(dto.getOplock());
		
		if (dto.getMyGoalsTaskActivities() != null) {
			for (MyGoalsTaskActivitiesDTO taDTO : dto.getMyGoalsTaskActivities()) {
				MyGoalTaskActivity ta = myGoalTaskActivityConverter.convert(taDTO);
				model.getMyGoalsTaskActivities().add(ta);
			}
		}
		
		return model;
	}
}
